<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('city_id', 'name', 'phone', 'email', 'photo', 'pin_code', 'password');

    public function losts()
    {
        return $this->hasMany('App\Models\Lost');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

}